# EveDeck

EVE preview/control panel for multi‑account setups.

## What is this?
EveDeck is a compact “mission control” for multiboxing in EVE Online: it shows live window previews in a grid and lets you jump to any client fast.

It is **not** EVE‑O Preview. It is basically EVE‑O Preview on crack — same idea, but built for deeper control, bigger account stacks, and custom layouts without the fuss.

## Getting started
1. Put `EveDeck.exe`, `EveDeck.config.ahk`, and your optional background image in the same folder.
2. Edit `EveDeck.config.ahk` and set your character window titles.
3. Launch `EveDeck.exe`.

## Requirements
- A secondary display for the control panel: either a tablet running Spacedesk (https://www.spacedesk.net/), or a portable touchscreen monitor or any monitor will work but you will not have touch controls and will have to rely on the hotkeys you setup.
- EveDeck targets the **right‑most** monitor for the control panel.


## Configure your accounts
Open `EveDeck.config.ahk` and update the `EVE_ACCOUNTS` list:

```
EVE_ACCOUNTS := [
  { account:"Acct 1", chars: [
      { name:"Pilot A", win:"EVE - Pilot A" },
      { name:"Pilot B", win:"EVE - Pilot B" },
  ]},
]
```

The `win` value must match the exact EVE window title.

## Layout (auto by default)
EveDeck auto‑sizes the grid based on your account count.  
To force a grid, set `EVE_ROWS` and `EVE_COLS` in the config.

## Common layouts
Edit these in `EveDeck.config.ahk`:

2 accounts (centered, with space above/below):
```
EVE_ROWS := 0
EVE_COLS := 0
```
This is the default auto layout.

2 accounts (side‑by‑side, full height):
```
EVE_ROWS := 1
EVE_COLS := 2
```

4 accounts (2×2):
```
EVE_ROWS := 2
EVE_COLS := 2
```

6 accounts (3×2):
```
EVE_ROWS := 2
EVE_COLS := 3
```

8 accounts (4×2):
```
EVE_ROWS := 2
EVE_COLS := 4
```


## Background image
Add a file named `bg.png` (or `bg.jpg`, `bg.jpeg`, `bg.bmp`, `bg.gif`) next to the EXE.

## Troubleshooting
- If a preview is “OFFLINE”, the window title in `EVE_ACCOUNTS` doesn’t match.
- Keep `EveDeck.config.ahk` in the same folder as the EXE.
