; EveDeck.config.ahk
; Configuration for EveDeck.ahk
; Keep this file next to EveDeck.ahk.

; ================== EVE ACCOUNT GROUPS ==================
; Add one entry per account. Each account has multiple character window titles.
EVE_ACCOUNTS := [
  { account:"Acct 1", chars: [
      { name:"Char 1", win:"EVE - " },
      { name:"Char 2",       win:"EVE - " },
      { name:"Char 3",        win:"EVE - " },
  ]},
  { account:"Acct 2", chars: [
      { name:"Char 1", win:"EVE - " },
      { name:"Char 2",       win:"EVE - " },
      { name:"Char 3",        win:"EVE - " },
  ]},
  { account:"Acct 3", chars: [
      { name:"Char 1", win:"EVE - " },
      { name:"Char 2",       win:"EVE - " },
      { name:"Char 3",        win:"EVE - " },
  ]},
  { account:"Acct 4", chars: [
      { name:"Char 1", win:"EVE - " },
      { name:"Char 2",       win:"EVE - " },
      { name:"Char 3",        win:"EVE - " },
  ]},
]

; ================== HOTKEYS ==================
; Hotkeys for the 4 primary preview slots.
HK_EVE1 := "F21"
HK_EVE2 := "F22"
HK_EVE3 := "F23"
HK_EVE4 := "F24"
; Extra hotkeys for slots 5+ (extend as needed).
HK_EVE_EXTRA := []  ; e.g. ["F25","F26"]

; Exit controls
HK_EXIT := "^!q"          ; Ctrl+Alt+Q exits the panel
HK_ESC_OVER_PANEL := true ; Esc exits only if cursor is over the panel window

; ================== BACKGROUND ==================
; Background opacity only (previews stay 100% opaque)
BG_OPACITY_PERCENT := 50   ; 0-100
; Background image: place bg.(png/jpg/jpeg/bmp/gif) next to the script.
BG_COLOR := "18212c"      ; fallback solid color when no image is found

; ================== GRID / LAYOUT ==================
; EVE tile grid (auto by default). With 2 accounts, auto makes a 1x2 layout.
; Set either rows or cols to 0 to auto-calc the other based on account count.
EVE_ROWS := 0
EVE_COLS := 0
EVE_SLOT_COUNT := 0  ; 0 = auto (use all accounts).

; Right column width (Mumble column). Set = HOLE_W to keep hole inside column.
RIGHT_COL_W := 400

; Tile layout spacing (px at 100% / 96 DPI)
PANEL_MARGIN := 8
TILE_GAP     := 8
LABEL_H      := 24   ; title strip height
LABEL_PAD_X  := 6
LABEL_PAD_Y  := 2
SUB_PAD_X    := 6
SUB_PAD_Y    := 6
TITLE_TEXT_BOTTOM_GAP := 2  ; gap between title strip and preview

; ================== TITLE BAR / LABELS ==================
; Title bar background (helps text legibility over images)
TITLE_BAR_ENABLED := true
TITLE_BAR_COLOR := "000000"
TITLE_BAR_OPACITY_PERCENT := 100   ; 0-100, applies only to bar (text stays full opacity)
TITLE_BAR_MODE := "full"          ; "full" or "text" (wrap just the title)
TITLE_TEXT_COLOR := "ffffff"

; Fonts (scaled) for tile labels
FONT_TITLE_PT := 16
FONT_SUB_PT   := 16
FONT_NAME     := "Segoe UI"

; ================== MUMBLE ==================
MUMBLE_ENABLED := false  ; enable Mumble click-through hole and thumbnail
MUMBLE_TITLE   := "Mumble"
MUMBLE_WIN     := "ahk_exe mumble.exe"

; Click-through HOLE (under Mumble, inside right column). Ignored if MUMBLE_ENABLED = false.
HOLE_ENABLED   := true
HOLE_W         := 500
HOLE_H         := 450
HOLE_GAP_ABOVE := 12
HOLE_INSET_X   := 0
HOLE_INSET_Y   := 0

; Thumbnail source area (helps framing)
EVE_CLIENT_ONLY    := true  ; only capture EVE client area, not full window
MUMBLE_CLIENT_ONLY := true  ; only capture Mumble client area, not full window

; ================== PREVIEW BEHAVIOR ==================
HIDE_ACTIVE_PREVIEW := false     ; hide the active EVE client's preview
PREVIEW_INACTIVE_OPACITY := 100  ; opacity for inactive EVE previews (20-100)

; ================== ACTIVE PREVIEW INDICATOR ==================
DEBUG_OVERLAY := false  ; show temporary on-screen debug info
FOCUS_ENABLED := true
FOCUS_STYLE := "frame"    ; "frame" | "corner" | "ribbon"
FOCUS_ONLY_EVE := true
FOCUS_FOLLOW_FOREGROUND := true

; Common focus colors
FOCUS_COLOR      := "9fa05e"     ; hex RGB (no 0x)
FOCUS_TEXT_COLOR := "FFFFFF"

; Frame settings
FOCUS_THICKNESS := 4            ; border thickness (px @ 100%)
FOCUS_INSET     := 2            ; used by corner position only (frame wraps full tile)

; Corner rectangle settings
FOCUS_CORNER_POS  := "top-right" ; top-right | top-left | bottom-right | bottom-left
FOCUS_CORNER_W    := 170
FOCUS_CORNER_H    := 28
FOCUS_CORNER_TEXT := "ACTIVE"

; Ribbon (45°) settings
FOCUS_RIBBON_POS       := "top-left" ; top-right | top-left | bottom-right | bottom-left
FOCUS_RIBBON_LEN       := 180         ; length of the ribbon band (px @ 100%)
FOCUS_RIBBON_THICKNESS := 28          ; thickness of the ribbon band (px @ 100%)
FOCUS_RIBBON_TEXT      := "ACTIVE"
FOCUS_RIBBON_INSET     := 1           ; gap between tile corner and ribbon band (px @ 100%)
